/*
 * Decompiled with CFR 0.152.
 */
package com.sinaflying.game;

import com.sinaflying.customise.Function;
import com.sinaflying.engine.Avatar;
import com.sinaflying.engine.KeyCode;
import com.sinaflying.engine.ResourceManager;
import com.sinaflying.game.MessageBoxHandler;
import com.sinaflying.game.Scene;
import javax.microedition.lcdui.Graphics;

class GameMessageBox {
    private MessageBoxHandler _handler;
    private static GameMessageBox _instance;
    private byte _style;
    private int _dialogPageNum;
    private int _dialogPage;
    private int _dialogWordOffset;
    private boolean _isCurrentPageFinish;
    private int _dialogFrameX;
    public int _dialogFrameY;
    public int _dialogFrameH;
    private int _dialogWordNumInLine;
    private int _actorTrueX;
    private int[] _pageShow;
    private int _singlePageFrameH;
    private int _singlePageInfoX;
    private int _singlePageInfoY;
    private int _singleBKY;
    private int _stayTime = 0;
    private int _imageAction;
    private int _imageFrame;
    private int _shopFrameY;
    private int _shopFrameH;
    private int _shopY;
    private int _buyPrice;
    private int _buyNum;
    private int _type;
    private int _tollNum;
    private String _nameTitle;
    private String[] _tempStr;
    private String[] _dialogContext = new String[100];
    private Avatar _imageAni;
    private boolean _isPressKeyDis = false;
    private int _itemY;
    private String[] _item;
    private int _chooseFrameY;
    private int _chooseFrameH;
    private int _chooseSpace;
    public int _itemIndex;
    private static int PER_PAGE_LINE;
    int _frm;

    private GameMessageBox() {
    }

    public final void draw(Graphics graphics) {
        switch (this._style) {
            case 0: {
                this.paintForDialogStyle(graphics);
                break;
            }
            case 1: {
                this.paintForSinglePageStyle(graphics);
                break;
            }
            case 2: {
                this.drawShopMessage(graphics);
                break;
            }
            case 3: {
                this.drawChoose(graphics);
            }
        }
    }

    public final void update() {
        switch (this._style) {
            case 0: {
                this.keyRespondForDialogStyle();
                break;
            }
            case 1: {
                this.keyRespondForSinglePageStyle();
                break;
            }
            case 2: {
                this.keyForShop();
                break;
            }
            case 3: {
                this.keyForChoose();
            }
        }
    }

    public final void initDialogStyle(int n, int n2, String string, String string2) {
        this.calculateFormatForDialog();
        this._style = 0;
        this._actorTrueX = n;
        this._dialogFrameX = 240 - Math.abs(n) >= 60 ? Math.abs(n) - 24 : Math.abs(n) - 40;
        this._dialogFrameY = Math.abs(n2);
        this._dialogWordNumInLine = 120 / Function.C_WORD_W;
        this.deivideDialog(string2);
        this.startupDialog();
    }

    private final void deivideDialog(String string) {
        int n;
        string = Function.initWordOffset(string);
        int n2 = this.getLineNum(string);
        this._pageShow = new int[n2];
        this.getPageNum(n2);
        int n3 = string.length();
        int n4 = 0;
        int n5 = 0;
        do {
            int n6 = (this._dialogWordNumInLine - 1) * this._pageShow[n5];
            n = Math.min(n4 + n6, n3);
            this._dialogContext[n5++] = string.substring(n4, n);
        } while ((n4 = n) < n3);
    }

    private int getLineNum(String string) {
        int n = string.length();
        int n2 = 0;
        n2 = n % (this._dialogWordNumInLine - 1) == 0 ? n / (this._dialogWordNumInLine - 1) : n / (this._dialogWordNumInLine - 1) + 1;
        return n2;
    }

    private void getPageNum(int n) {
        int n2 = 0;
        this._dialogPageNum = 0;
        do {
            int n3;
            if ((n3 = n - n2) / PER_PAGE_LINE == 0) {
                this._pageShow[this._dialogPageNum] = n % PER_PAGE_LINE;
                ++this._dialogPageNum;
                break;
            }
            this._pageShow[this._dialogPageNum] = PER_PAGE_LINE;
            ++this._dialogPageNum;
        } while ((n2 = PER_PAGE_LINE * this._dialogPageNum) < n);
    }

    private final void startupDialog() {
        this._dialogPage = -1;
        this.nextPage();
    }

    private final void nextPage() {
        ++this._dialogPage;
        this._dialogWordOffset = 0;
        this._isCurrentPageFinish = false;
    }

    public final boolean isExistNextPage() {
        return this._dialogPage < this._dialogPageNum - 1;
    }

    private final void calculateFormatForDialog() {
        try {
            int n;
            this._dialogFrameH = n = Function.C_WORD_H * 2;
            this._dialogFrameY = 320 - this._dialogFrameH;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private final void paintForDialogStyle(Graphics graphics) {
        this.drawFrame(graphics);
        this.drawDialogContent(graphics);
    }

    private final void drawFrame(Graphics graphics) {
        graphics.setClip(0, 0, 240, 320);
        int n = this._dialogFrameX;
        int n2 = this._dialogFrameY;
        int n3 = this.getFrameStartX(n);
        if (this._actorTrueX < 0) {
            n = 30;
            n2 = 160;
        } else if (this._actorTrueX > 240) {
            n = 180;
            n2 = 160;
        }
        int n4 = n2 - 14;
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(n3 + 8, n4 - 11 - Function.C_WORD_H * this._pageShow[this._dialogPage], 122, Function.C_WORD_H * this._pageShow[this._dialogPage] + 22);
        graphics.fillRect(n3, n4 - Function.C_WORD_H * this._pageShow[this._dialogPage], 8, Function.C_WORD_H * this._pageShow[this._dialogPage]);
        graphics.fillRect(n3 + 120 + 10, n4 - Function.C_WORD_H * this._pageShow[this._dialogPage], 8, Function.C_WORD_H * this._pageShow[this._dialogPage]);
        ResourceManager._spts[83].draw(graphics, n3, n4 - 11 - Function.C_WORD_H * this._pageShow[this._dialogPage], 0, 0, 0x10 | 4);
        ResourceManager._spts[83].draw(graphics, n3, n4 + 11, 0x40000000, 0, 0x10 | 4);
        ResourceManager._spts[83].draw(graphics, n3 + 120 + 10, n4, 1, 0, 0x10 | 4);
        ResourceManager._spts[83].draw(graphics, n3 + 120 + 10, n4 - Function.C_WORD_H * this._pageShow[this._dialogPage], 0x40000001, 0, 0x10 | 4);
        int n5 = this.getFrameFilpX(this._actorTrueX, 2);
        ResourceManager._spts[83].draw(graphics, n, n2 - 3, n5, 0, 0x10 | 4);
    }

    public int getFrameStartX(int n) {
        n = this._actorTrueX < 0 ? 1 : (n - 60 <= 0 ? 1 : (this._actorTrueX - 180 >= 0 ? 100 : n - 60 + 5));
        return n;
    }

    public int getFrameFilpX(int n, int n2) {
        n2 = this._actorTrueX < 0 ? -2147483646 : 2;
        return n2;
    }

    private final void drawDialogContent(Graphics graphics) {
        int n = this._dialogFrameX;
        int n2 = this._dialogFrameY;
        int n3 = this.getFrameStartX(n) + 4;
        if (this._actorTrueX < 0) {
            n2 = 160;
        } else if (this._actorTrueX > 240) {
            n2 = 160;
        }
        int n4 = n2 - 14 - Function.C_WORD_H * this._pageShow[this._dialogPage];
        this._isCurrentPageFinish = Function.drawWordOffset(graphics, n3, n4, Function.C_WORD_W, Function.C_WORD_H, this._dialogContext[this._dialogPage], this._dialogWordOffset, this._dialogWordNumInLine - 1, 0);
        if (this._isCurrentPageFinish) {
            this._frm = ++this._frm > Scene._resource.getAvatation(80).getActFrmNum(28) - 1 ? 0 : this._frm;
            Scene._resource.getAvatation(80).draw(graphics, n3 + 120, n2 - 20, 28, this._frm, 0);
        }
    }

    private final void keyRespondForDialogStyle() {
        ++this._dialogWordOffset;
        int n = KeyCode.getCurKey();
        switch (n) {
            case 16: {
                this._dialogWordOffset += 5;
                if (this._isCurrentPageFinish) {
                    if (this.isExistNextPage()) {
                        this.nextPage();
                    } else {
                        this.finishShowHandler();
                    }
                }
                KeyCode.resetCurKey();
                break;
            }
            default: {
                KeyCode.resetCurKey();
            }
        }
    }

    private final void calculateFormatForSinglePage() {
        this._singlePageInfoX = 120;
        this._singlePageInfoY = 320 - Function.C_WORD_H >> 1;
    }

    public final void initSinglePageStyle(int n, int n2, String string, int n3) {
        this.calculateFormatForSinglePage();
        n3 = 0;
        this._imageFrame = 0;
        int n4 = 0;
        if (n != 0) {
            this._imageAni = Scene._resource.loadAvatar(n, 0);
            this._imageAction = n2;
            n4 = this._imageAni._b[this._imageAction] - this._imageAni._t[this._imageAction];
        } else {
            this._imageAni = null;
        }
        int n5 = (240 - 2 * Function.C_WORD_W) / Function.C_WORD_W;
        this._tempStr = Function.subString(string, n5);
        this._singlePageFrameH = (Function.C_WORD_H + 1) * this._tempStr.length + 20 + n4;
        this._singleBKY = 160 - this._singlePageFrameH / 2;
        this._singlePageInfoY = this._singleBKY + 10 + n4;
        this._stayTime = n3;
        this._isPressKeyDis = n3 <= 0;
        this._style = 1;
        Function.initAlphaArray(0xFFFFFF, 70);
    }

    private final void paintForSinglePageStyle(Graphics graphics) {
        graphics.setClip(0, 0, 240, 320);
        Function.drawFrame(graphics, this._singleBKY, this._singlePageFrameH);
        if (this._imageAni != null) {
            this._imageAni.draw(graphics, 100, this._singlePageInfoY - 10, this._imageAction, this._imageFrame, 0);
            ++this._imageFrame;
            if (this._imageFrame > this._imageAni.getActFrmNum(this._imageAction) - 1) {
                this._imageFrame = 0;
            }
        }
        graphics.setClip(0, 0, 240, 320);
        graphics.setColor(0);
        int n = 0;
        while (n < this._tempStr.length) {
            graphics.drawString(this._tempStr[n], this._singlePageInfoX, this._singlePageInfoY + n * (Function.C_WORD_H + 1), 1 | 0x10);
            ++n;
        }
    }

    private final void keyRespondForSinglePageStyle() {
        int n = KeyCode.getCurKey();
        if (this._isPressKeyDis) {
            if (n == 16) {
                this._imageAni = null;
                this.finishShowHandler();
            }
        } else if (--this._stayTime < 0) {
            this._stayTime = 0;
            this._imageAni = null;
            this.finishShowHandler();
        }
    }

    public void initShopStyle(int n, String string) {
        this._style = (byte)2;
        this._nameTitle = string;
        this._buyNum = 0;
        this._type = n;
        if (this._type == 0) {
            this._shopFrameH = 4 * Function.C_WORD_H + 2;
            this._shopFrameY = (320 - this._shopFrameH) / 2;
            this._shopY = this._shopFrameY + 2 * Function.C_WORD_H;
        } else {
            this._shopFrameH = 3 * Function.C_WORD_H + 2;
            this._shopFrameY = (320 - this._shopFrameH) / 2;
            this._shopY = this._shopFrameY + Function.C_WORD_H;
        }
        Function.initAlphaArray(0xFFFFFF, 85);
    }

    public void initShopBuy(int n, int n2) {
        this._buyPrice = n;
        this._tollNum = n2 / n;
    }

    public void initShopSell(int n, int n2) {
        this._buyPrice = n;
        this._tollNum = n2;
    }

    public void drawShopMessage(Graphics graphics) {
        Function.drawFrame(graphics, this._shopFrameY, this._shopFrameH);
        graphics.setColor(0);
        if (this._type == 0) {
            graphics.drawString(this._buyPrice + "   x ", 86, this._shopY + Function.C_WORD_H - 2, 8 | 0x20);
            graphics.drawString(this._buyNum + "", 96 + Function.C_WORD_W, this._shopY, 1 | 0x10);
            graphics.drawString(" = " + this._buyPrice * this._buyNum, Function.C_WORD_W * 3 + 96, this._shopY, 4 | 0x10);
            graphics.setColor(0);
            graphics.drawRect(96, this._shopY - 2, Function.C_WORD_W * 2, Function.C_WORD_H);
            graphics.fillTriangle(99, this._shopY - 4, 96 + Function.C_WORD_W * 2 - 3, this._shopY - 4, 96 + Function.C_WORD_W, this._shopY - 9);
            graphics.fillTriangle(99, this._shopY + Function.C_WORD_H, 96 + Function.C_WORD_W * 2 - 3, this._shopY + Function.C_WORD_H, 96 + Function.C_WORD_W, this._shopY + Function.C_WORD_H + 5);
            graphics.drawString(this._nameTitle + ":", 30, this._shopY - Function.C_WORD_H - 5, 0x10 | 4);
        } else {
            graphics.drawString(this._nameTitle, 120, this._shopY, 0x10 | 1);
        }
        graphics.setClip(0, 0, 240, 320);
        Function.drawYesNoKey(graphics, true, true);
    }

    public void keyForShop() {
        if (KeyCode.isPressConfirmSoftKey()) {
            this.notifyHandlerForShop();
            KeyCode.resetCurKey();
            return;
        }
        if (KeyCode.isPressCancelKey()) {
            this.notifyHandlerForCancel();
            KeyCode.resetCurKey();
            return;
        }
        if (this._type == 0) {
            int n = KeyCode.getCurKey();
            KeyCode.resetCurKey();
            switch (n) {
                case 4: {
                    ++this._buyNum;
                    if (this._buyNum < this._tollNum) break;
                    this._buyNum = this._tollNum;
                    break;
                }
                case 8: {
                    --this._buyNum;
                    if (this._buyNum >= 0) break;
                    this._buyNum = 0;
                }
            }
        }
    }

    public void initChooseStyle(String[] stringArray) {
        this._style = (byte)3;
        this._item = stringArray;
        this._chooseSpace = Function.C_WORD_H + 2;
        this._itemIndex = 0;
        this._chooseFrameH = stringArray.length * this._chooseSpace + Function.C_WORD_H;
        this._chooseFrameY = (320 - this._chooseFrameH) / 2;
        this._itemY = this._chooseFrameY + Function.C_WORD_H / 2;
        Function.initAlphaArray(0xFFFFFF, 85);
    }

    public void drawChoose(Graphics graphics) {
        Function.drawFrame(graphics, this._chooseFrameY, this._chooseFrameH);
        GameMessageBox.drawItem(graphics, 120, this._itemY, this._item, this._chooseSpace, this._itemIndex, 0x10 | 1);
    }

    public static void drawItem(Graphics graphics, int n, int n2, String[] stringArray, int n3, int n4, int n5) {
        int n6 = 0;
        while (n6 < stringArray.length) {
            if (n6 == n4) {
                graphics.setColor(0xFFAF00);
                graphics.fillArc((240 - stringArray[n6].length() * Function.C_WORD_W) / 2 - 15, n2 + 2 + n6 * n3, 10, 10, 0, 360);
            }
            graphics.setColor(0);
            graphics.drawString(stringArray[n6], n, n2 + n6 * n3, n5);
            ++n6;
        }
        graphics.setClip(0, 0, 240, 320);
        Function.drawYesNoKey(graphics, true, true);
    }

    public void keyForChoose() {
        if (KeyCode.isPressConfirmKey()) {
            this.notifyHandlerForResult(this._itemIndex);
            KeyCode.resetCurKey();
            return;
        }
        if (KeyCode.isPressCancelKey()) {
            this.notifyHandlerForCancel();
            KeyCode.resetCurKey();
            return;
        }
        int n = KeyCode.getCurKey();
        KeyCode.resetCurKey();
        switch (n) {
            case 4: {
                --this._itemIndex;
                if (this._itemIndex >= 0) break;
                this._itemIndex = this._item.length - 1;
                break;
            }
            case 8: {
                ++this._itemIndex;
                if (this._itemIndex <= this._item.length - 1) break;
                this._itemIndex = 0;
            }
        }
    }

    public static final GameMessageBox getInstance(MessageBoxHandler messageBoxHandler) {
        if (_instance == null) {
            _instance = new GameMessageBox();
        }
        _instance.init(messageBoxHandler);
        return _instance;
    }

    public void finishShowHandler() {
        MessageBoxHandler messageBoxHandler = this._handler;
        this.dispose();
        messageBoxHandler.finishHandle();
    }

    public void notifyHandlerForResult(int n) {
        MessageBoxHandler messageBoxHandler = this._handler;
        this.dispose();
        messageBoxHandler.resultHandle(n);
    }

    public void notifyHandlerForShop() {
        MessageBoxHandler messageBoxHandler = this._handler;
        this.dispose();
        messageBoxHandler.shopResultHandle(this._buyNum);
    }

    public void notifyHandlerForCancel() {
        MessageBoxHandler messageBoxHandler = this._handler;
        this.dispose();
        messageBoxHandler.cancelHandle();
    }

    public void dispose() {
        this._handler = null;
        KeyCode.resetCurKey();
    }

    public void init(MessageBoxHandler messageBoxHandler) {
        this._handler = messageBoxHandler;
    }

    static {
        PER_PAGE_LINE = 3;
    }
}

